/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.pa.ar;

import com.ibm.hwmca.base.pa.ar.CommonDataAnalysisRoutine;
import com.ibm.hwmca.base.pa.incident.HmcIncident;
import com.ibm.hwmca.fw.domain.DomainManager;
import com.ibm.hwmca.fw.pa.event.ProblemAnalysisEvent;
import com.ibm.hwmca.fw.pa.event.ProblemAnalysisEventListener;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.domain.DistributedAnalysisDomain;
import com.ibm.hwmca.xfw.pa.event.DistributedDataEvent;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;

public class DistributedDataEventAnalysisRoutine
extends CommonDataAnalysisRoutine
implements ProblemAnalysisEventListener {
    private static final String TRACE_MASKT = "XPADDEAT";
    private static final String TRACE_MASKF = "XPADDEAF";
    private static final String TRACE_MASKD = "XPADDEAD";
    protected HmcIncident anIncident = null;
    protected DistributedAnalysisDomain eventDomain = null;

    public DistributedDataEventAnalysisRoutine() {
        Trace.trace(TRACE_MASKD, "<-> ctor");
    }

    public void analyze(ProblemAnalysisEvent event) {
        Trace.trace(TRACE_MASKD, "--> analyze()");
        DistributedDataEvent ourEvent = (DistributedDataEvent)event;
        Trace.trace(TRACE_MASKD, "event domain: " + ourEvent.getDomainId().getDID());
        this.eventDomain = (DistributedAnalysisDomain)DomainManager.getDomainManager().get(ourEvent.getDomainId());
        if (this.eventDomain == null) {
            Trace.trace(TRACE_MASKT, "<-- analyze(): cannot obtain domain for event");
            return;
        }
        Trace.trace(TRACE_MASKD, "Create a problem");
        CommonProblem aProblem = null;
        try {
            aProblem = this.instantiateProblem(ourEvent);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "<-- analyze: couldn't create problem: ");
            Trace.trace(TRACE_MASKT, e);
            return;
        }
        if (aProblem == null) {
            Trace.trace(TRACE_MASKT, "<-- analyze: no problem created");
            return;
        }
        this.anIncident = new HmcIncident();
        this.anIncident.setProblem(aProblem);
        Trace.trace(TRACE_MASKD, "Time of the incident = " + this.anIncident.getTimestamp().getTime());
        aProblem.setRefcode(ourEvent.getRefcode());
        aProblem.setExtension(ourEvent.getExtension());
        aProblem.setSkipVPD(false);
        aProblem.setSkipRSF(false);
        aProblem.setReplicatable(true);
        this.anIncident.setPriority(ourEvent.getPriority());
        Trace.trace(TRACE_MASKD, "<-- DistributedDataEventAnalysisRoutine analyze()");
    }
}

